
public class ComputerPlayer extends Player
{
    protected boolean possiblePeople[];
    protected boolean possibleLocations[];
    protected boolean possibeWeapons[];

  
    protected boolean[] createBooleanArray(int size, boolean value)
    {
        boolean [] returnVal = new boolean[size];
        for (int i = 0; i < size; i++)
        {
            returnVal[i] = value;
        }
        return returnVal;
    }
    
    protected void addCard(Card c)
    {
        if (c.type().equals("Location"))
        {
            possibleLocations[c.cardNum()] = false;
        }
        else if (c.type().equals("Weapon"))
        {
            possibeWeapons[c.cardNum()] = false;
        }
        else 
        {
            possiblePeople[c.cardNum()] = false;
        }
    }
    
    public ComputerPlayer(Hand myHand, int playerNumber)
    {
        super(myHand, playerNumber);
        possiblePeople = createBooleanArray(PersonCard.cardsOfType(), true);
        possibleLocations = createBooleanArray(LocationCard.cardsOfType(), true);
        possibeWeapons = createBooleanArray(WeaponCard.cardsOfType(), true);
        
        for (int i = 0; i < myHand.size(); i++)
        {
            addCard(myHand.get(i));
        }
    }

    @Override
    public void AccusationRefuted(Accusation accusationMade, Card card,
            int player)
    {
        if (card  != null)
        {
            addCard(card);
        }
    }

    @Override
    public Card CheckAccusation(Accusation acc, int accusingPlayer)
    {
        Hand wrong = new Hand();
        for (int i = 0; i < myHand.size(); i++)
        {
            if (myHand.get(i).equals(acc.person))
            {
                wrong.add(myHand.get(i));
            }
            if (myHand.get(i).equals(acc.weapon))
            {
                wrong.add(myHand.get(i));
            }
            if (myHand.get(i).equals(acc.location))
            {
                wrong.add(myHand.get(i));
            }            
        }
        if (wrong.size() == 0)
        {
            return null;
        }
        else
        {
            wrong.shuffle();
            return wrong.removeTop();
        }
    }

    @Override
    public void OtherPlayerAccusation(Accusation accusationMade,
            int accusingPlayer, int refutingPlayer)
    {

    }

    @Override
    public Accusation makeAccusation()
    {
        PersonCard pc = null;
        WeaponCard wc = null;
        LocationCard lc = null;
        for (int i = 0; i < PersonCard.cardsOfType(); i++)
        {
            if (possiblePeople[i])
            {
                pc = new PersonCard(i);
                break;
            }            
        }
        for (int i = 0; i < WeaponCard.cardsOfType(); i++)
        {
            if (possibeWeapons[i])
            {
                wc = new WeaponCard(i);
                break;
            }
        }
        for (int i = 0; i < LocationCard.cardsOfType(); i++)
        {
            if (possibleLocations[i])
            {
                lc = new LocationCard(i);
                break;
            }
        }
        return new Accusation(pc,lc,wc);        
        
    }

}
