import java.util.Scanner;


public class Deduction
{
    private Hand allCards;
    private PersonCard guiltyPerson;
    private LocationCard location;
    private WeaponCard weapon;

    private Hand[] hands;
    private Player players[];
    private int numPlayers;

    public void setup()
    {       
        Hand people = new Hand();
        Hand locations = new Hand();
        Hand weapons = new Hand();

        for (int i = 0; i < PersonCard.cardsOfType(); i++)
        {
            people.add(new PersonCard(i));
        }
        for (int i = 0; i < WeaponCard.cardsOfType(); i++)
        {
            weapons.add(new WeaponCard(i));
        }
        for (int i = 0; i < LocationCard.cardsOfType(); i++)
        {
            locations.add(new LocationCard(i));
        }
        people.shuffle();
        weapons.shuffle();
        locations.shuffle();
        guiltyPerson = (PersonCard) people.removeTop();
        location = (LocationCard) locations.removeTop();
        weapon = (WeaponCard) weapons.removeTop();

        allCards = new Hand();

        while(people.size() > 0)
        {
            allCards.add(people.removeTop());
        }
        while(locations.size() > 0)
        {
            allCards.add(locations.removeTop());
        }
        while(weapons.size() > 0)
        {
            allCards.add(weapons.removeTop());
        }
    }

    public void deal()
    {
        hands = new Hand[numPlayers];
        for (int i = 0; i < numPlayers; i++)
        {
            hands[i] = new Hand();
        }
        for (int i = 0; i < allCards.size(); i++)
        {
            hands[i%numPlayers].add(allCards.get(i));
        }
    }



    public void playGame(int humanPlayers, int computerPlayers)
    {
        numPlayers = humanPlayers + computerPlayers;
        players = new Player[numPlayers];
        setup();
        deal();
        int playerIndex = 0;
        for (int i = 0; i < humanPlayers; i++,playerIndex++)
        {
            players[playerIndex] = new HumanPlayer(hands[playerIndex], playerIndex);
            ((HumanPlayer) players[playerIndex]).PrintHand();
        }
        for (int i = 0; i < computerPlayers; i++,playerIndex++)
        {
            players[playerIndex] = new ComputerPlayer(hands[playerIndex], playerIndex);
        }

        boolean gameOver = false;
        int currentPlayer = 0;
        while (!gameOver)
        {
            Accusation acc = players[currentPlayer].makeAccusation();

            Card refutingCard = null;
            int refutingPlayer = -1;
            for (int i = 1; i < numPlayers  && refutingCard == null; i++)
            {
                refutingCard = players[(currentPlayer + i) % numPlayers].CheckAccusation(acc, currentPlayer);
                if (refutingCard != null)
                {
                    refutingPlayer  = (currentPlayer+i)%numPlayers;
                }                
            }
            players[currentPlayer].AccusationRefuted(acc,refutingCard,refutingPlayer);
            for (int i = 0; i < numPlayers; i++)
            {
                if (i != currentPlayer)
                {
                    players[i].OtherPlayerAccusation(acc, currentPlayer, refutingPlayer);
                }
            }

            if (accusationCorrect(acc))
            {
                System.out.println("Player " + currentPlayer + " wins with accusation " + acc);
                gameOver = true;
            }

            currentPlayer = (currentPlayer + 1) % numPlayers;

        }

    }

    private boolean accusationCorrect(Accusation acc)
    {
        return acc.person.equals(guiltyPerson) && acc.weapon.equals(weapon) && acc.location.equals(location);
    }




    public static void main(String args[])
    {
        Scanner scan = new Scanner(System.in);

        System.out.println("Enter number of Computer Players:");
        int computerPlayers = scan.nextInt();
        System.out.println("Enter number of Human Players:");
        int humanPlayers = scan.nextInt();
        Deduction d = new Deduction();
        d.playGame(humanPlayers, computerPlayers);

    }





}
