import java.util.Random;

public class Hand
{
    public static final int DEFAULT_ALLOCATED_SIZE = 10;
    protected Card[] cards;
    protected int handSize = 0;
    
    /**
     * Create a hand that initially has enough space to store allocatedSize cards
     * @param allocatedSize Amount of space to initially allocate for the hand
     */
    public Hand(int allocatedSize)
    {
        cards = new Card[allocatedSize];        
    }
    
    public Hand()
    {
        cards = new Card[DEFAULT_ALLOCATED_SIZE];
        
    }
    
    protected void growAllocatedSize()
    {
        Card newHand[] = new Card[cards.length*2];
        for (int i = 0; i < cards.length; i++)
        {
            newHand[i] = cards[i];
        }
        cards = newHand;
    }
    
    
    /**
     * Add a card to the end of the hand.  This *may* require the allocated size to increase
     * @param c The card to add to the hand
     */
    public void add(Card c)
    {
        if (handSize == cards.length)
        {
            growAllocatedSize();
        }
        cards[handSize++] = c;        
    }
    
    /**
     * Remove (and return) the card at the "top" of the hand
     * (last added card, assuming the hand was not shuffled)
     * @return The card that was removed from the hand
     */
    public Card removeTop()
    {
        return cards[--handSize];
    }
    
    /**
     * Get a card at a specific index in the had. This method does not
     * change the hand at all
     * @param index The index of the card to get.  index must be greater 
     * or equal to zero, and less than size()
     * @return The card at index 'index' in the hand
     */
    public Card get(int index)
    {
        return cards[index];
    }
    
    /**
     * Get the size (number of cards in the hand)
     * @return the number of cards in the hand
     */
    public int size()
    {
        return handSize;
    }
    
    /**
     * Shuffle the hand, so that subsequent calls to get (or removeTop)
     * will return different values. 
     */
    public void shuffle()
    {
        Random r = new Random();
        
        for (int i = 0; i < handSize - 1; i++)
        {
            int swapLocation = r.nextInt(handSize - i) + i;
            Card tmp = cards[i];
            cards[i] = cards[swapLocation];
            cards[swapLocation] = tmp;
        }
    }
    

}
