import java.util.Scanner;


public class HumanPlayer extends Player
{
    private Scanner scan;
    public HumanPlayer(Hand myHand, int myNumber)
    {
        super(myHand, myNumber);       
        scan = new Scanner(System.in);
    }

    
    public void PrintHand()
    {
        System.out.println("Player " + playerNumber + " hand:");
        for (int i = 0; i < myHand.size(); i++)
        {
            System.out.println(myHand.get(i));
        }
    }

    @Override
    public Card CheckAccusation(Accusation acc, int accusingPlayer)
    {
        Hand wrong = new Hand();
        for (int i = 0; i < myHand.size(); i++)
        {
            if (myHand.get(i).equals(acc.person))
            {
                wrong.add(myHand.get(i));
            }
            if (myHand.get(i).equals(acc.weapon))
            {
                wrong.add(myHand.get(i));
            }
            if (myHand.get(i).equals(acc.location))
            {
                wrong.add(myHand.get(i));
            }            
        }
        System.out.println("Player " + playerNumber + ".  Accusation made by " +accusingPlayer);
        System.out.println(acc);
        
        if (wrong.size() > 0)
        {
            int index = -1;
            while (index < 0 || index >= wrong.size())
            {
                System.out.println("Pick a card to show to refute Accusation");
                for (int i = 0; i < wrong.size(); i++)
                {
                    System.out.println(Integer.toString(i) + ": " + wrong.get(i));                
                }
                index = scan.nextInt();
            }
            return wrong.get(index);
        }
        else
        {
            System.out.println("Player " + playerNumber + " does not have a card to refute Accusation");
            return null;
        }
    }

    @Override
    public Accusation makeAccusation()
    {
        System.out.println("Player " + playerNumber);
        int personIndex = -1;
        while (personIndex < 0 || personIndex >= PersonCard.cardsOfType())
        {
            System.out.println("Pick a person to accuse:");
            for (int i = 0; i < PersonCard.cardsOfType(); i++)
            {
                System.out.println(Integer.toString(i) + ": " + new PersonCard(i));
            }
            personIndex = scan.nextInt();
        }
        int weaponIndex = -1;
        while (weaponIndex < 0 || weaponIndex >= WeaponCard.cardsOfType())
        {
            System.out.println("Pick a Weapon:");
            for (int i = 0; i < WeaponCard.cardsOfType(); i++)
            {
                System.out.println(Integer.toString(i) + ": " + new WeaponCard(i));
            }
            weaponIndex = scan.nextInt();
        }
        int locationIndex = -1;
        while (locationIndex < 0 || locationIndex >= LocationCard.cardsOfType())
        {
            System.out.println("Pick a Location:");
            for (int i = 0; i < LocationCard.cardsOfType(); i++)
            {
                System.out.println(Integer.toString(i) + ": " + new LocationCard(i));
            }
            locationIndex = scan.nextInt();
        }
        return new Accusation(new PersonCard(personIndex), new LocationCard(locationIndex), new WeaponCard(weaponIndex));
    }


    @Override
    public void AccusationRefuted(Accusation accusationMade, Card card, int player)
    {
        System.out.println("Message to Player " + playerNumber+":");        
        if (card != null)
        {
            System.out.println("  Accusation " + accusationMade + " refuted by player " + player + " with card " + card);
        }
        else
        {
            System.out.println("  Accusation " + accusationMade + " not refuted");
        }
        
    }


    @Override
    public void OtherPlayerAccusation(Accusation accusationMade, int accusingPlayer, int refutingPlayer)
    {
        System.out.println("Message to Player " + playerNumber+":");  
        if (refutingPlayer >= 0)
        {
            System.out.println("  Accusation " + accusationMade + " made by player " + accusingPlayer + " refuted by player " + refutingPlayer);
        }
        else
        {
            System.out.println("  Accusation " + accusationMade + " made by player " + accusingPlayer + " not refuted");
            
        }
        
    }
}
