
public class LocationCard extends Card
{
    static final String Locations[] = {"Kudlick Room", "Laptop Lab", "Library", "CS Office", "Dean's Office", "K Hall",
                                        "Harney Hallway", "Lone Mountain", "UC"};
    
    
    /**
     * Create a LocationCard with the given ID
     * 
     * @param locationID: the ID of the location
     */    
    public LocationCard(int locationID)
    {
        if (locationID < 0 || locationID >= Locations.length)
        {
            // Exception?
        }
        ID = locationID;   
    }
    /**
     * Create a LocationCard with the given name
     * 
     * @param name: The name of the person to create.  Must be one of 
     * the following: "Kudlick Room", "Laptop Lab", "Library", "CS Office", 
     *                 "Dean's Office", "K Hall", "Harney Hallway", 
     *                 "Lone Mountain", "UC"
     */
    public LocationCard(String name)
    {
        ID = findIndex(Locations, name);    
    }

    /**
     * Return the type of this card, which is "Location"
     * @return The type of the card ("Location")
     */
    @Override
    public String type()
    {
        return "Location";
    }

    
    /**
     * Return the name of the card ("Kudlick Room", "Laptop Lab", etc)
     * @return The name of the card
     */
    @Override
    public String cardName()
    {
       return Locations[ID];
    }
    
    /**
     * Return a string representation of the card, which contains both
     * the String "Location" and the name of the card
     * @return string representation of the card, containing both "Location" and the name of the card
     */
    @Override
    public String toString()
    {
        return "Location Card: " + cardName();
    }

    
    /**
     * Return the number of cards of this type (in this case 9, but you should
     * base this on the static constant array of strings that stores the actual names
     */
    public static int cardsOfType()
    {
        return Locations.length;
    }

}
