
public class PersonCard extends Card
{

    static final String People[] = {"Benson", "Galles", "Jung", "Pacheco", "Rollins", "Wolber"};
        
    
    /**
     * Create a PersonCard with the given ID
     * 
     * @param personID: the ID of the person to create
     */    

    public PersonCard(int personID)
    {
        if (personID < 0 || personID >= People.length)
        {
            // Exception?
        }
        ID = personID;   
    }
    
    /**
     * Create a PersonCard with the given name
     * 
     * @param name: The name of the person to create.  Must be one of 
     * the following: "Benson", "Galles", "Jung", "Pacheco", "Rollins", "Wolber"
     */

    public PersonCard(String name)
    {
        ID = findIndex(People, name);    
    }

    /**
     * Return the type of this card, which is "Person"
     * @return The type of the card ("Person")
     */
    @Override
    public String type()
    {
        return "Person";
    }
    
    /**
     * Return the name of the card ("Benson", "Galles", etc)
     * @return The name of the card
     */
    @Override
    public String cardName()
    {
        return People[ID];
    }

    /**
     * Return a string representation of the card, which contains both
     * the String "Person" and the name of the card
     * @return string representation of the card, containing both "Person" and the name of the card
     */

    @Override
    public String toString()
    {
        return "Person Card: " + cardName();
    }

    /**
     * Return the number of cards of this type (in this case 6, but you should
     * base this on the static constant array of strings that stores the actual names
     */
    public static int cardsOfType()
    {
        return People.length;
    }


}
