
public abstract class Player
{    
    protected Hand myHand;
    protected int playerNumber;
    
    public Player(Hand myHand, int playerNumber)
    {
        this.myHand = myHand;
        this.playerNumber = playerNumber;
    }
    
    public String toString()
    {
        return "Player " + playerNumber;
    }
    
    /**
     * This method is called by the main program when this player's accusation has been refuted.  
     * The main program will first call the makeAccusation method of this class to make the
     * actual accusation, and then the main program will discover who can refute this
     * accusation, and then call this method to inform this player how the accusation was refuted
     * @param accusationMade The accusation that was made
     * @param card The card that refutes the accusation (or null if there is no refutation)
     * @param player the player that refuted the accusation (or -1 if there is no refutation)
     */
    public abstract void AccusationRefuted(Accusation accusationMade, Card card, int player);
    
    /**
     * This method is called when an accusation is made by some other player, and then refuted 
     * by a different other player.  For human players, a message should be printed to the
     * screen, computer players will need to store this information to make better guesses in 
     * the future
     * @param accusationMade The accusation that was made
     * @param accusingPlayer The player that made the accusation
     * @param player the player that refuted the accusation (or -1 if there was no refutation)
     */    
    public abstract void OtherPlayerAccusation(Accusation accusationMade, int accusingPlayer, int refutingPlayer);
    
    /**
     * This method is called by the main program when it is this player's turn to make an accusation.  
     * The player decides what accusation to make (for a human player by prompting the human for
     * input, for a computer player by deciding in code), and returns the accusation
     * @return The accusation for this player to make
     */
    public abstract Accusation makeAccusation();
    /**
     * This method is called when a different player has made an accusation, and this player
     * needs to check to see if the accusation is valid.  If this player has a card that
     * refutes the accusation, then return that card.  If this player does not have a card
     * that refutes the accusation, return null
     * @param acc The accusation that was made
     * @return A card that refutes this accusation, or null if this player does not have a card
     *         to refute this accusation
     */
    public abstract Card CheckAccusation(Accusation acc, int accusingPlayer);
}
