
public class WeaponCard extends Card
{
    static final String Weapons[] = {"Laptop", "Smartphone", "Router", "Cable", "Monitor", "Keyboard"};
       
   
    
    /**
     * Create a WeaponCard with the given ID
     * 
     * @param weaponID: the ID of the weapon
     */    
    public WeaponCard(int weaponID)
    {
        if (weaponID < 0 || weaponID >= Weapons.length)
        {
            // Exception?
        }
        ID = weaponID;   
    }
    
    /**
     * Create a WeaponCard with the given name
     * 
     * @param name: The name of the weapon to create.  Must be one of 
     * the following: "Laptop", "Smartphone", "Router", "Cable", "Monitor", "Keyboard"
     */
    public WeaponCard(String name)
    {
        ID = findIndex(Weapons, name);    
    }
        
    /**
     * Return the type of this card, which is "Weapon"
     * @return The type of the card ("Weapon")
     */
    @Override
    public String type()
    {
        return "Weapon";
    }

    /**
     * Return the name of the card ("Lapton", "Smartphone", etc)
     * @return The name of the card
     */
    @Override
    public String cardName()
    {
        return Weapons[ID];
    }
    
    @Override
    /**
     * Return a string representation of the card, which contains both
     * the String "Weapon" and the name of the card
     * @return string representation of the card, containing both "Weapon" and the name of the card
     */
    public String toString()
    {
        return "Weapon Card: " + cardName();
    }
    

    /**
     * Return the number of cards of this type (in this case 6, but you should
     * base this on the static constant array of strings that stores the actual names
     */
    public static int cardsOfType()
    {
        return Weapons.length;
    }

}
