
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileReader;

import java.io.IOException;

import java.net.Socket;

//import org.apache.log4j.Logger;
//import org.apache.log4j.PropertyConfigurator;

/*
 * Determine request type information from clients and admin. Calls the appropriate handlers.
 */
public class ConnectionHandler extends ClassLoader{

	String query="";
	String result="";

	private BufferedInputStream input=null;
	private int admin_port = 8082;
	private DataOutputStream output=null;
	//private static Logger logger = Logger.getLogger(ConnectionHandler.class);


	public void processrequest(Socket socket)
	{
		int local_port = socket.getLocalPort();
		//PropertyConfigurator.configure("config.properties");

		try{
			input = new BufferedInputStream( (socket).getInputStream() );
			output=new DataOutputStream(socket.getOutputStream());
		}catch(Exception e){e.printStackTrace();}

		try {
			char incoming_request_char =0;
			String incoming_request_string ="";
			
			while((incoming_request_char =(char)input.read()) != ':') {
				incoming_request_string=incoming_request_string+incoming_request_char;
			}
			
			//logger.info( "Incoming string"+incoming_request_string);
			
			//processing registration requests
			if (incoming_request_string.contains("Registration request")){
				char incoming_address_char=0;
				String incoming_address_string = "";
				while ((incoming_address_char = (char)input.read()) != '/') {
					incoming_address_string=incoming_address_string+incoming_address_char;
				}
				//logger.info( "Next incoming string"+incoming_address_string);
				RegistrationHandler rh = new RegistrationHandler();
				output.writeUTF(rh.registerClient(incoming_address_string));
			}
			//processing file transfer request
			else if(incoming_request_string.contains("File Transfer")){
				char incoming_address_char=0;
				String incoming_address_string = "";
				
				while ((incoming_address_char = (char)input.read()) != ':') {
					incoming_address_string=incoming_address_string+incoming_address_char;
				}
				char incoming_file_char=0;
				String incoming_file_string = "";
				
				while ((incoming_file_char = (char)input.read()) != '/') {
					incoming_file_string=incoming_file_string+incoming_file_char;
				}

				//logger.info( "Next incoming string"+incoming_address_string);
				DataHandler dh = new DataHandler();
				dh.getFile(output, incoming_file_string,incoming_address_string);
			}
			//processing server shutdown request from admin users
			else if((incoming_request_string.contains("Server shutdown request"))&&(local_port==admin_port)){
				//logger.info("Incoming String"+incoming_request_string);
				char incoming_username_char=0;
				String incoming_username_string = "";
				char incoming_password_char=0;
				String incoming_password_string = "";
				
				while ((incoming_username_char = (char)input.read()) != ':') {
					incoming_username_string=incoming_username_string+incoming_username_char;
				}
				
				//logger.info("Incoming Username"+incoming_username_string);

				while ((incoming_password_char = (char)input.read()) != '/') {
					incoming_password_string=incoming_password_string+incoming_password_char;
				}

				//logger.info(socket.getLocalPort());
				BufferedReader input = null;
				input = new BufferedReader( new FileReader("AdminDetails.dat") );
				String line = null; 
				String authenticate = "true";
				
				//authentication mechanism
				while (( line = input.readLine()) != null){
					if(line.startsWith("Username")){
						if (!incoming_username_string.equals(line.substring(line.indexOf("=")+1))){
							authenticate = "false";
						}  
					}
					if(line.startsWith("Password")){
						if (!incoming_password_string.equals(line.substring(line.indexOf("=")+1))){
							authenticate = "false";
						}  
					}
				}

				if (authenticate == "true")  {
					output.writeUTF("Server shutdown successfully");
					socket.close();
					Server sv = new Server(8080, 50, "ConnectionHandler", 2000, 5, 10 );
					sv.shutdown();	
				}
				else{
					output.writeUTF("Wrong Admin username/password");
				}
			}
		} catch (IOException e1) {
			// TODO Auto-generated catch block
		  e1.printStackTrace();
		}
	}

}

