import java.io.FileInputStream;
import java.util.Properties;


/*
 * Takes as input the client value properties file and 
 * creates a new client
 */

public class Client{

	public String propertiesFile = null;
	public SystemProfiler systemprofiler = null;
	public MacSystemParameters systemparameters = null;
	public FileHandler filehandler = null;
	public PropertyFileValues propertyfilevalues = null;
	public ClientServerSync clientserversync = null;

	//Main method
	public static void main(String[] args) {
		System.loadLibrary("WinSysapp");
		new Client("ClientValues.properties");
	}


	//Sets-up the beans and runs them
	public Client(String parameterFileName){

		//System.out.println(" "+parameterFileName);
		
		setupObjects(parameterFileName);

		try
		{
			propertyfilevalues.initialize();
			systemprofiler.getSystemProfile();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}

	}


	//Creates the objects
	void setupObjects(String parameterFileName) {

		try{	
			this.propertiesFile = parameterFileName;
			Properties defaultProp = new Properties();
			FileInputStream in = new FileInputStream(this.propertiesFile);
			System.out.println(" "+this.propertiesFile);
			defaultProp.load(in);
			in.close();
			System.out.println(" "+defaultProp.getProperty("sleeptime"));
			systemprofiler = new SystemProfiler(new Integer(defaultProp.getProperty("sleeptime")).intValue());
			propertyfilevalues = new PropertyFileValues(defaultProp.getProperty("connection_server"),defaultProp.getProperty("output_dir")
					,defaultProp.getProperty("llama_server"),defaultProp.getProperty("register_id")
					,defaultProp.getProperty("pdf_recharges")
					,defaultProp.getProperty("app_energyinfo")
					, defaultProp.getProperty("probability")
					, defaultProp.getProperty("Archives")
					, new Long(defaultProp.getProperty("sleeptime")).longValue()
					, defaultProp.getProperty("logfiles")
					, new Long(defaultProp.getProperty("sleeptime")).longValue());
			System.out.println("The archive file "+defaultProp.getProperty("logfiles"));
	     }
		catch (Exception e)
		{
		 e.printStackTrace();		
		 System.out.println("Exception :" + e.getCause()	+ " :: " + e.getStackTrace());
		}
		//System.out.println("PropertiesFile = " + this.propertiesFile);
	}

}
