import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;

/*
 * handles storing readings into files named according to the date. also moves files to the archive directory
 */
public class FileHandler {

//	Store Parameters on Disk
	public void storetempFiles(List paramlist, String file_name){
		try {	
			FileOutputStream stream = new FileOutputStream(PropertyFileValues.destination_dir+file_name+".txt", true);
			OutputStreamWriter out = new OutputStreamWriter(stream, "US-ASCII");
			out.write(String.valueOf(paramlist.get(0)));
			out.write("\n");
			out.write(String.valueOf(paramlist.get(1)));
			out.write("\n");
			out.write("battery ");
			out.write(String.valueOf(paramlist.get(2)));
			out.write("\n");
			out.write("onAC ");
			out.write(String.valueOf(paramlist.get(3)));
			out.write("\n");
			out.write("cpu ");
			out.write(String.valueOf(paramlist.get(4)));
			out.write("\n");
			out.write("disk ");
			out.write(String.valueOf(paramlist.get(5)));
			out.write("\n");
			out.write("connected ");
			out.write(String.valueOf(paramlist.get(6)));
			out.write("\n");
			out.write("idle_time ");
			out.write(String.valueOf(paramlist.get(7)));
			out.write("\n");
			out.close();
			stream.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void moveFileToArchive(String file_name){
		File file = new File(PropertyFileValues.destination_dir+file_name);
		// Destination directory
		File dir = new File(PropertyFileValues.destination_dir+"Archive");
		// Move file to new directory
		boolean success = file.renameTo(new File(dir, file.getName()));
		if (!success) {
			// File was not successfully moved
			System.out.println("Unable to move file!");
		}


	}

}
