import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.net.*;


/**
 * 
 */

/**
 * abstract class. gets the date, date in milliseconds and checks connection status
 *
 */
abstract class SystemParameters {

	//	Calculate the median value
	double getMedian(double[] met_nums){
		Arrays.sort(met_nums);
		return met_nums[((met_nums.length+1)/2)-1];
	}


	//	Get system Date
	String getDate(){
		Date today = new Date();
		SimpleDateFormat sd = new SimpleDateFormat("E MMM dd H:mm:ss z yyyy");
		String date = sd.format(today);		
		return date;
	}


	//Get system date in milliseconds
	long getDateInMilliseconds(){
		Date date = new Date();
		long date_in_milliseconds = date.getTime();
		return date_in_milliseconds;
	}


	//	Check if the system is connected to the internet
	String getConnection(){
		InetAddress address;
		//PropertyFileValues.address="sdds";
		try {
			address = InetAddress.getByName(PropertyFileValues.address);
			address.getHostName();
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			//e.printStackTrace();
			return "false";
		}
		return "true";
	}


	abstract double getCpu();
	abstract int getBateryRemaining();
	abstract int getAc();
	abstract double getDisk();
	abstract double getIdleTime();
	abstract List Scheduler();


}
