import java.util.*;


/*
 * Retrieves system parameters at a predefined interval
 */
public class SystemProfiler {

	SystemParameters sysparams;

 public SystemProfiler(int SleepInterval)
 {
	 this.setSleepInterval(sleepInterval);
 }

	//Checks OS type and runs the timer to reequest for parameters at a specified interval
	public void getSystemProfile(){
		String os_name, os_arch;
		os_name = System.getProperty( "os.name" );
		os_arch = System.getProperty( "os.arch" );
		System.out.println(os_name + "\n"+ os_arch);
		int delay = 0;   // delay for 0 sec.
		int period = 1000*this.getSleepInterval();  // repeat every sec*no of secs in ClientValues.properties.
		Timer timer = new Timer();

		if (os_name.equals("Mac OS X"))
		{ 
		  sysparams = new MacSystemParameters();
		}
		else
		{
		  System.out.println("OS type not supported");
		}
		
		timer.scheduleAtFixedRate(new ClientTimerTask(sysparams), delay, period);
	}






	/*******************Setters and Getters******************/
	protected int sleepInterval;




	public int getSleepInterval() {
		return sleepInterval;
	}

	public void setSleepInterval(int sleepInterval) {
		this.sleepInterval = sleepInterval;
	}




}

