import java.io.File;


/*
 * Reads in values from the properties file
 */
public class PropertyFileValues {

	public static String address;
	public static String destination_dir;
	public static String install_dir;
	public static String llamaserver;
	public static String registrationid;
	public static String [] file_list;

	public PropertyFileValues(String serverAddress, String outputDirectory, 
			String llamaServer, String registrationId)
	{
	 this.setServerAddress(serverAddress);
	 this.setLlamaServer(llamaServer);
	 this.setOutputDirectory(outputDirectory);
	 this.setRegistrationId(registrationId);
	}
	
	
	public void initialize(){
		address=this.serverAddress;
		destination_dir=this.outputDirectory;
		install_dir=this.installDirectory;
		file_list=getFileList();
		llamaserver=this.llamaServer;
		registrationid=this.registrationId;
		makeDir(destination_dir+"Archive");
		makeDir(destination_dir);

	}

	//makes the archive directory
	private void makeDir(String dir_name){
		File f = new File(dir_name);
		f.mkdir();
	}
	
	//gets the list of files in the data directory
	public String[] getFileList(){
		File dir = new File(destination_dir);
		return dir.list();
	}



	/*******************Setters and Getters******************/
	protected String serverAddress;
	protected String outputDirectory;
	protected String installDirectory;
	protected String llamaServer;
	protected String registrationId;
	protected String lastDate;

	public String getServerAddress() {
		return serverAddress;
	}

	public void setServerAddress(String serverAddress) {
		this.serverAddress = serverAddress;
	}

	public String getOutputDirectory() {
		return outputDirectory;
	}

	public void setOutputDirectory(String outputDirectory) {
		this.outputDirectory = outputDirectory;
	} 
	
	public String getInstallDirectory() {
		return installDirectory;
	}

	public void setInstallDirectory(String installDirectory) {
		this.installDirectory = installDirectory;
	} 


	public String getLlamaServer() {
		return llamaServer;
	}

	public void setLlamaServer(String llamaServer) {
		this.llamaServer = llamaServer;
	}

	public String getRegistrationId() {
		return registrationId;
	}

	public void setRegistrationId(String registrationId) {
		this.registrationId = registrationId;
	}

	public String getLastDate() {
		return lastDate;
	}

	public void setLastDate(String lastDate) {
		this.lastDate = lastDate;
	}
}
