from RandomArray import *
from eventqueues import *
from events import *
from config import *
import pickle, random
from simconstants import * 

class AppData:
    def __init__(self, dates, totalonline):
        self.dates = dates
        self.totalonline = totalonline

def main(argv=None):
    """
    Sample usage of the EventGenerator

    for each event
        -change state of relevant node
        -if node came online
          *initiate join (update neighborlists as appropriate)
        -if node left
          *initiate rejoin for children if necessary
        -apply supernode selection criteria (does a new supernode need to be selected/a current node demoted?)
        -record statistics (e.g., time online, battery, failure rate)
    
    """

    config = Config()
    fname = config.params[PROGRAM][DATADIR]

    deq = DeviceEventGenerator(fname)
    aeq = AppEventGenerator(deq.appdatanodes)
    
    f = open("../appeventgen.P", "w")
    pickle.dump(aeq, f)
    f.close()
    
    """
    i = 1
    while aeq.hasNext():
        ev = aeq.getNextEvent()
        print "Event ", i
        i += 1    
        ev.display()
    """  
if (__name__ == "__main__"):
    sys.exit(main())

