"""
Author: Sami Rollins
"""
import sys, os, email, datetime
from email import Utils
#from events import *
#from appeventgen import *

class Test:
    def __init__(self):
        self.num = 10

class StateChange:
    "The StateChange class maintains information about the most recent state change."
    def __init__(self, date=0, onchange=0, batchange=0, onacchange=0, ison=0, bat=0, onac=0):
        """
        Constructor takes as input the date of the state change, True/False to indicate
        whether there has been an on/off change, a battery change, or an onAC change, and values
        for isOn, battery, and onAC.
        """
        if(date != 0 and not(isinstance(date, datetime.datetime))):
            self.date = self.createDateObject(date)
        else:
            self.date = date
        self.onchange = onchange
        self.batchange = batchange
        self.onacchange = onacchange
        self.ison = ison
        try:
            self.bat = int(bat)
        except:
            self.bat = 0
            #print "BAT IS X - BATCHAGE IS ", self.batchange
        self.onac = onac

    def createDateObject(self, date):
        """
        Helper to create a datetime object from a date.
        """
        timestamp = email.Utils.mktime_tz(email.Utils.parsedate_tz(date))
        utcdate = datetime.datetime.fromtimestamp(timestamp)
        return utcdate

    def setVals(self, measurement):
        """
        UGH - hacky method because python is weird about overloading constructors
        """
        self.date = self.createDateObject(measurement.date)
        self.onchange = True
        self.batchange = True
        self.onacchange = True
        if measurement.conn == '1':
            self.ison = True
        else:
            self.ison = False
        try:
            self.bat = int(measurement.bat)
        except:
            self.bat = 0
            print "BAT IS X - BATCHAGE IS ", self.batchange
        if(measurement.onac == '1'):
            self.onac = True
        else:
            self.onac = False

    def display(self):
        """
        Display StateChange data.
        """
        print self.date
        if(self.onchange == True):
            print "\ton/off state changed ", self.ison
        if(self.batchange == True):
            print "\tbattery state changed ", self.bat
        if(self.onacchange == True):
            print "\tplugged state changed ", self.onac

class Measurement:
    "The Measurement class maintains data about a single data measurement."
    def __init__(self, date, bat, onac, conn):
        """
        Constructor takes as input the date of the measurement,
        the battery status, the onac status, and connectivity status.
        """
        self.date = date
        self.bat = bat
        self.onac = onac
        self.conn = conn

    def stateChange(self, measurement, laststatechange):
        """
        The stateChange method takes as input a measurement and the previous
        StateChange.  The method returns a StateChange object if a StateChange has
        happened between the Measurement on which7 the method is called and the measurement
        passed as input.  If no state change has happened, the method returns None.
        """
        onchange = False
        batchange = False
        onacchange = False

        ison = False
        bat = self.bat
        onac = False
        
        #did node turn off
        if self.conn == '1' and (measurement.conn == 'M' or measurement.conn == '0'):
            onchange = True
            ison = False
        #did node turn on
        elif ((self.conn == '0' or self.conn == 'M') and measurement.conn == '1'):
            onchange = True
            ison = True
        elif(measurement.conn == '1'):
            ison = True
        elif(measurement.conn == '0'  or measurement.conn == 'M'):
            ison = False

        #did node plug in
        if(laststatechange != None and ((laststatechange.onac == False and measurement.onac == '1') or
                                  laststatechange.onac == True and measurement.onac == '0')):
            onacchange = True
        if measurement.onac == '1':
            onac = True
        elif measurement.onac == '0':
            onac = False
        else:
            onac = laststatechange.onac

        #did battery change
        if(laststatechange != None and laststatechange.bat != measurement.bat and measurement.bat != 'M'):
            batchange = True
        if(batchange == False or measurement.bat == 'M'):
            bat = laststatechange.bat
        else:
            bat = measurement.bat

        #if there has been a change, return a new StateChange
        if(onchange == True or batchange == True or onacchange == True):
            return StateChange(measurement.date, onchange, batchange, onacchange, ison, bat, onac)
        return None
            

class DeviceTraceData:
    "The NodeTraceData class maintains a list of StateChange events for a single node."
    def __init__(self, id):
        self.events = []
        self.id = id



def main(argv=None):
    """
    Sample usage of the EventGenerator
    """
    fname = "../test_data"
    argv = sys.argv
    if len(argv) > 1:
        fname = argv[1]
        #print "fname", fname
    e = DeviceEventGenerator(fname)
    while e.hasNext():
        ev = e.getNextEvent()
        #ev.display()


if (__name__ == "__main__"):
    sys.exit(main())






