import email, time, datetime
from simconstants import *

class Event:
    def __init__(self, id, date):
        self.id = id
        self.date = date

    def display(self):
        print "ID: ", self.id
        print "Time: ", self.date

class DeviceEvent(Event):
    "The Event class maintains data about a single event."

    def __init__(self, id, date, stateinfo, changeinfo):
        Event.__init__(self, id, date)
        self.stateinfo = stateinfo
        self.changeinfo = changeinfo
    
    def display(self):
        print "ID: ", self.id
        print "\t", self.date
        print "\tON: ", self.stateinfo.ison
        print "\tBAT: ", self.stateinfo.bat
        print "\tAC: ", self.stateinfo.onac
        print "\tONCHANGE: ", self.changeinfo.onchange
        print "\tBATCHANGE: ", self.changeinfo.batchange
        print "\tACCHANGE: ", self.changeinfo.onacchange

class DeviceStateInfo:
    def __init__(self, ison=0, bat=0, onac=0):
        self.ison = ison
        self.bat = bat
        self.onac = onac

class DeviceChangeInfo:
    def __init__(self, onchange=0, batchange=0, onacchange=0):
        self.onchange = onchange
        self.batchange = batchange
        self.onacchange = onacchange

class CommEvent(Event):
    def __init__(self, id, date, sendid, type):
        Event.__init__(self, id, date)
        self.sendid = sendid
        self.type = type
        
class SimEvent(Event):
    def __init__(self, id, date, sendid, type):
        Event.__init__(self, id, date)
        self.sendid = sendid
        self.type = type
        
    def generateEvent(self, sender):
        if sender.devicestate.ison and self.type == PING:
            return CommEvent(self.id, (self.date+sender.commstate.sendtime), self.sendid, self.type)
        #else:
            #print "PING FAILED BECAUSE ", self.sendid, " WENT OFFLINE"
        
class AppEvent(Event):
    def __init__(self, id, date, sendid, destid, sendchain, type, starttime = None):
        Event.__init__(self, id, date)
        self.sendid = sendid
        self.destid = destid
        self.sendchain = sendchain
        if starttime == None:
            self.starttime = date
        else:    
            self.starttime = starttime
        self.type = type
            
    def display(self):
        print "AppEvent"
        print "\tid ", self.id
        print "\tdate ", self.date
        print "\tsendid ", self.sendid
        print "\tdestid ", self.destid
        print "\tsendchain ", self.sendchain
        print "\tstarttime ", self.starttime
        print "\ttype ", self.type

class AppIDEvent(AppEvent):
    def __init__(self, id, date, sendid, destid, sendchain, type, starttime, evid):
        AppEvent.__init__(self, id, date, sendid, destid, sendchain, type, starttime)
        self.evid = evid

class AppQueryEvent(AppIDEvent):
    def __init__(self, id, date, sendid, destid, sendchain, type, starttime, evid, devicestate = None):
        AppIDEvent.__init__(self, id, date, sendid, destid, sendchain, type, starttime, evid)
        self.devicestate = devicestate
