import random, statistics
from network_utils import *
from events import *

            
class FlatNode(Node):
    
    def startLeave(self, date, onlineNodes):
        pass
    
    def startJoin(self, date, onlineNodes):
        self.commstate.neighborlist = []
        #if the num of nodes online is small, add all to my neighborlist
        if (len(onlineNodes)-1) < self.commstate.numneighbors:
            for i in onlineNodes:
                if i.id != self.id:
                    self.commstate.neighborlist.append(i.id)
                    self.timeconnected[i.id] = date
                    
        else:
            if self.appstate.algorithm == RANDOM:
                self.chooseRandom(date, onlineNodes)
            elif self.appstate.algorithm == UPTIME or self.appstate.algorithm == BATTERY:
                self.chooseBest(date, onlineNodes)
            
        events = []
        prevdate = date    
        #for each node added, send a PING
        for i in self.commstate.neighborlist:
            events.append(CommEvent(i, prevdate+self.commstate.delay, self.id, PING))
            prevdate = prevdate+self.commstate.sendtime
        
        return events

    def chooseRandom(self, date, onlineNodes):
        #choose random set of nodes
        nindex = {}
        while len(self.commstate.neighborlist) < self.commstate.numneighbors:
            num = random.randint(0, len(onlineNodes)-1)
            if nindex.has_key(num) or onlineNodes[num].id == self.id:
                continue
            nindex[num] = True
            self.commstate.neighborlist.append(onlineNodes[num].id)
            self.timeconnected[onlineNodes[num].id] = date 
  
    def chooseBest(self, date, onlineNodes):
        while len(self.commstate.neighborlist) < self.commstate.numneighbors:
            
            maxtime = onlineNodes[0]
            mti = 0
            maxbat = onlineNodes[0]
            mbi = 0
            
            for i in range(len(onlineNodes)):
                if i == 0:
                    continue
                if date-onlineNodes[i].devicestate.timeon > date-maxtime.devicestate.timeon:
                    maxtime = onlineNodes[i]
                    mti = i
                if onlineNodes[i].devicestate.bat > maxbat.devicestate.bat:
                    maxbat = onlineNodes[i]
                    mbi = i
            if self.appstate.algorithm == BATTERY:
                self.commstate.neighborlist.append(maxbat.id)
                self.timeconnected[maxbat.id] = date 
                del onlineNodes[mbi]
            else:
                self.commstate.neighborlist.append(maxtime.id)
                self.timeconnected[maxtime.id] = date 
                del onlineNodes[mti]
    
    
    def applyCommEvent(self, event):
        #if the msg is PING and i am on, send a PONG 
        if event.type == PING and self.devicestate.ison:
            events = []
            #print "RETURING PONG id: ", self.id, " sendid: ", event.sendid, " time: ", (event.date+self.commstate.delay) 
            #if i need more neighbors, add this node
            if len(self.commstate.neighborlist) < self.commstate.numneighbors:
                isneighbor = False
                for i in self.commstate.neighborlist:
                    if i == event.sendid:
                        isneighbor = True
                if not(isneighbor):
                    self.commstate.neighborlist.append(event.sendid)
                    self.timeconnected[event.sendid] = event.date
                    #print "adding ", event.sendid, " to my neighborlist"
                    events.append(SimEvent(event.sendid, (event.date+self.commstate.refreshinterval), self.id, PING))
            events.append(CommEvent(event.sendid, (event.date+self.commstate.delay), self.id, PONG))
            return events
        if event.type == PING and not(self.devicestate.ison):
            #print "RETURING FAIL id: ", self.id, " sendid: ", event.sendid, " time: ", (event.date+self.commstate.delay)
            #return that PING failed, dest node not on
            return CommEvent(event.sendid, (event.date+self.commstate.delay), self.id, FAIL)         
        
        
        if event.type == PONG and self.devicestate.ison:
            #print "send another ping in X min"
            return SimEvent(event.sendid, (event.date+self.commstate.refreshinterval), self.id, PING)

        if event.type == FAIL and self.devicestate.ison:
            #remove failed node from my neighborlist
            for i in range(len(self.commstate.neighborlist)):
                if self.commstate.neighborlist[i] == event.sendid:
                    #print "removing ", event.sendid, " from neighborlist"
                    statistics.conntimes.append((event.date-self.timeconnected[self.commstate.neighborlist[i]]))
                    self.timeconnected[self.commstate.neighborlist[i]] = None
                    del self.commstate.neighborlist[i]
                    break
  
    def applyAppEvent(self, event):

        if(event.type == ORIG and not(self.devicestate.ison)):
            #print "FATAL ERROR"
            statistics.orig_msg_failed += 1
            return None
        
        if event.destid == self.id:            
            if not(self.devicestate.ison):
                statistics.not_on_msg_rcvd += 1
                if isinstance(event, AppIDEvent):
                    return AppIDEvent(event.sendid, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, FAIL, event.starttime, event.evid)
                else:
                    return AppEvent(event.sendid, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, FAIL, event.starttime)

            #print "received message destined for me"
            statistics.rcvd.append(statistics.Stats(event.date, event.starttime, len(event.sendchain))) #time, hops
            return None
            
        if (event.type == GETDATA or event.type == PASS) and not(self.devicestate.ison):
            if isinstance(event, AppIDEvent):
                return AppIDEvent(event.sendid, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, FAIL, event.starttime, event.evid)
            else:
                return AppEvent(event.sendid, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, FAIL, event.starttime)
                
        if event.type == RETRY and not(self.devicestate.ison):
            statistics.node_w_msg_failed += 1
            #return None
            return AppEvent(self.id, (event.date+self.commstate.refreshinterval), event.sendid, event.destid, event.sendchain, RETRY, event.starttime)        

                
        if self.appstate.algorithm == RANDOM:
            return self.routeRandom(event)
        elif self.appstate.algorithm == FLOOD:
            return self.routeFlood(event)
        elif self.appstate.algorithm == UPTIME or self.appstate.algorithm == BATTERY:
            return self.routeBest(event)
        
    def routeFlood(self, event):
        try:
            self.attempts == None
        except:
            self.attempts = {}
            self.evids = 1

        if event.type == FAIL:
            #remove sendid from neighborlist and reroute using standard algorithm
            for i in range(len(self.commstate.neighborlist)):
                if self.commstate.neighborlist[i] == event.sendid:
                    statistics.conntimes.append(event.date-self.timeconnected[self.commstate.neighborlist[i]])
                    self.timeconnected[self.commstate.neighborlist[i]] = None
                    del self.commstate.neighborlist[i]
                    self.attempts[event.evid] = self.attempts[event.evid] - 1
                    if self.attempts[event.evid] == 0:
                        break
                    else:
                        return

        events = []
        possibles = self.getPossNeighbors(event.sendchain)
        for i in possibles:            
            events.append(AppIDEvent(i, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, PASS, event.starttime, self.evids))

        self.attempts[self.evids] = len(events)
        self.evids += 1
        if len(events) == 0:
            #print "sending retry to myself"
            return AppEvent(self.id, (event.date+self.commstate.refreshinterval), event.sendid, event.destid, event.sendchain, RETRY, event.starttime)		

        event.sendchain.append(self.id)
        return events           
    
    def routeRandom(self,event):
        if event.type == FAIL:
            #remove sendid from neighborlist and reroute using standard algorithm
            for i in range(len(self.commstate.neighborlist)):
                if self.commstate.neighborlist[i] == event.sendid:
                    statistics.conntimes.append(event.date-self.timeconnected[self.commstate.neighborlist[i]])
                    self.timeconnected[self.commstate.neighborlist[i]] = None
                    del self.commstate.neighborlist[i]
                    break
        
        toid = None
        #if the dest is in my neighborlist, send directly to dest
        for i in self.commstate.neighborlist:
            if i == event.destid:
                toid = i
        #dest not found, choose a random neighbor
        if toid == None:
            possibles = self.getPossNeighbors(event.sendchain)
            #if there are no possible nodes to send to
            #  remind myself to try to send again in (refreshinterval) minutes
            if len(possibles) == 0:
                #print "sending retry"
                return AppEvent(self.id, (event.date+self.commstate.refreshinterval), event.sendid, event.destid, event.sendchain, RETRY, event.starttime)
            num = random.randint(0, len(possibles)-1)
            toid = possibles[num]
            #print "possibles ", toid, " me ", self.id, " chain ", event.sendchain
            
        event.sendchain.append(self.id)
        #print "passing to ", toid, " sender ", self.id, " time ", (event.date+self.commstate.delay)
        return AppEvent(toid, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, PASS, event.starttime)
        
        
    def routeBest(self, event):
        try:
            self.initialized == None
        except:
            self.outstanding = {}
            self.maxtimes = {}
            self.evids = 1
            self.initialized = True

        if event.type == FAIL:
            #remove sendid from neighborlist 
            for i in range(len(self.commstate.neighborlist)):
                if self.commstate.neighborlist[i] == event.sendid:
                    #print "removing ", event.sendid, " from neighborlist"
                    statistics.conntimes.append(event.date-self.timeconnected[self.commstate.neighborlist[i]])
                    self.timeconnected[self.commstate.neighborlist[i]] = None
                    del self.commstate.neighborlist[i]
                    break
            #print "fail"
            #destination node failed - retry the original message (may need to start with query)
            if event.sendid == event.destid or self.outstanding[event.evid] == None:
                #probably can retry in this round.
                return AppEvent(self.id, (event.date+self.commstate.refreshinterval), event.sendid, event.destid, event.sendchain, RETRY, event.starttime)
            self.outstanding[event.evid] = self.outstanding[event.evid]-1
            if self.outstanding[event.evid] == 0:
                return AppIDEvent(self.id, (event.date+self.commstate.refreshinterval), event.sendid, event.destid, event.sendchain, RETRY, event.starttime, event.evid)
            return
                         
        elif event.type == QUERY:
            if not(self.devicestate.ison):
                return AppQueryEvent(event.sendid, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, FAIL, event.starttime, event.evid)
            #print self.id, " returning uptime as ", (event.date-self.devicestate.timeon), " for event ", event.evid
            return AppQueryEvent(event.sendid, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, REPLY, event.starttime, event.evid, self.devicestate)
        elif event.type == REPLY:
            #if this is not the last response, add to queue
            if self.outstanding[event.evid] > 1:
                #print "adding reply for ID: ", event.evid, " to queue"
                if self.maxtimes.has_key(event.evid):
                    times = self.maxtimes[event.evid]
                else:
                    times = []
                times.append(event)
                self.maxtimes[event.evid] = times
                self.outstanding[event.evid] = self.outstanding[event.evid] - 1
            else:
                 self.outstanding[event.evid] = None
                 times = self.maxtimes[event.evid]
                 maxtime = event
                 maxbat = event
                 #print "*****"
                 #print "time ", (event.date-maxtime.devicestate.timeon)
                 #print "id ", maxtime.sendid
                 for i in times:
                     if (event.date-i.devicestate.timeon) > (event.date-maxtime.devicestate.timeon):
                         maxtime = i
                     #print "time ", (event.date-i.devicestate.timeon)
                     #print "id ", i.sendid
                 #print "bat ", maxbat.devicestate.bat, " onac ", maxbat.devicestate.onac
                 #print "id ", maxbat.sendid
                 for i in times:
                     #print "Comparing ", i.batreply, " to ", maxbat.batreply
                     if int(i.devicestate.bat) > int(maxbat.devicestate.bat):
                         maxbat = i
                         #print "replacing with ", i.batreply
                     #print "bat ", i.devicestate.bat, " onac ", i.devicestate.onac
                     #print "id ", i.sendid
                 self.maxtimes[event.evid] = None 
                 """
                 if maxtime != maxbat:
                     print "NOT SAME"
                 else:
                     print "SAME"
                """
                 #print "max bat ", maxbat.sendid
                 #if maxbat.devicestate.onac == True:
                 #    print "ONAC"
                 #else:
                 #    print "NOT ONAC"
                 #print "max up ", maxtime.sendid
                 #print "*****"
                 if not(len(event.sendchain) > 0 and event.sendchain[len(event.sendchain)-1] == self.id):
                     event.sendchain.append(self.id)
                 if self.appstate.algorithm == BATTERY:
                     #print event.sendchain
                     return AppQueryEvent(maxbat.sendid, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, PASS, event.starttime, event.evid)
                 else: #should be uptime
                     return AppQueryEvent(maxtime.sendid, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, PASS, event.starttime, event.evid)
                     
        else:  #if event.type == ORIG or event.type == RETRY or event.type == PASS:
            toid = None
            #if the dest is in my neighborlist, send directly to dest
            for i in self.commstate.neighborlist:
                if i == event.destid:
                    #if i am not already at the end of the sendchain (e.g., i put myself there and then there was a failure), then add myself
                    if not(len(event.sendchain) > 0 and event.sendchain[len(event.sendchain)-1] == self.id):
                        event.sendchain.append(self.id)
                    return AppEvent(i, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, PASS, event.starttime)

            #dest is not in my neighborlist; send queries
            events = []
            possibles = self.getPossNeighbors(event.sendchain)
            for i in possibles:
                #print "adding ", i, " to events"
                events.append(AppQueryEvent(i, (event.date+self.commstate.delay), self.id, event.destid, event.sendchain, QUERY, event.starttime, self.evids))
            if len(events) == 0:
                return AppEvent(self.id, (event.date+self.commstate.refreshinterval), event.sendid, event.destid, event.sendchain, RETRY, event.starttime)
            self.outstanding[self.evids] = len(events)
            self.maxtimes[self.evids] = []
            self.evids += 1
            #print "returning ", len(events), " events ID: ", (self.evids-1)
            return events
    
        #ping all neighbors
        #choose neighbor online longest
        
        
    def getPossNeighbors(self, sendchain):
        possibles = []
        for j in self.commstate.neighborlist:
            contains = False
            for i in sendchain:
                if i == j:
                    contains = True
            if not(contains):
                possibles.append(j)
        return possibles
        
        
