import random, datetime, statistics
"""
State of the actual device.
"""
class DeviceState:
    def __init__(self, ison, bat, onac):
        self.ison = ison
        self.bat = bat
        self.onac = onac
        self.timeon = None
        self.timeac = None
        self.batrchg = 0
        self.demoted = False
        self.passed = False
        self.batwhenpassed = 0
        self.acwhenpassed = False
        self.timeonwhenpassed = None
        self.issuper = False
        self.timepromoted = None
        self.timenotacsuper = None
        self.totalnotacsuper = None
        self.totalassuper = None
        self.totalon = None
        #self.acchange = False
        #self.pluginwhilesuper = 0
        
    def promoteSuper(self, date):
        #print "promoted ", self
        self.issuper = True
        self.timepromoted = date
        #self.acchange = False
        self.pluginwhilesuper = 0
        if not(self.onac):
            self.timenotacsuper = date
        else:
            self.timenotacsuper = None
        self.totalnotacsuper = None
        
    def demoteSuper(self, date):
        #print "demoted ", self
        #print "NUMBER: ", self.pluginwhilesuper, " ", self
        self.issuper = False
        statistics.selectfreq.append(date-self.timepromoted)
        if self.totalassuper != None:
            self.totalassuper += (date-self.timepromoted)
        else:
            self.totalassuper = (date-self.timepromoted)
        if not(self.onac):
            if self.totalnotacsuper == None:
                self.totalnotacsuper = date-self.timenotacsuper
            else:
                self.totalnotacsuper += (date-self.timenotacsuper)
        if self.totalnotacsuper != None and self.getMinutes(self.totalnotacsuper) > 0:
            #statistics.timesnotac.append(int((float(self.getMinutes(self.totalnotacsuper))/self.getMinutes((date-self.timepromoted))*100)))
            percentnotac = float(self.getMinutes(self.totalnotacsuper))/self.getMinutes(date-self.timepromoted)
            percentnotac = 100.0*(percentnotac)
            intpercent = int(percentnotac)
            statistics.timesnotac.append(  intpercent  )
            #testing - to figure out uptime/random problem
            #statistics.timesnotac.append(self.getMinutes(self.totalnotacsuper))
        else:
            statistics.timesnotac.append(0)
            
    def getMinutes(self, i):
        daymins = i.days*24*60
        secmins = i.seconds/60
        return (daymins+secmins)
    
    def dumpStatistics(self):
        if self.totalassuper != None:
            val = float(self.getMinutes(self.totalassuper))/self.getMinutes(self.totalon)
            val = 100.0*val
            valpercent = int(val)
            statistics.percentassuper.append(valpercent)
            #print valpercent, "%"
        else:
            statistics.percentassuper.append(0)
            #print "never super"
        
    def changeState(self, date, stateinfo, changeinfo):
       
        if changeinfo.batchange:
            self.bat = stateinfo.bat
        if changeinfo.onchange:
            self.ison = stateinfo.ison
            #if the node just turned on, record time turned on
            if stateinfo.ison:
                self.timeon = date
                self.demoted = False
                self.passed = False
            else:
                if self.totalon == None:
                    self.totalon = date-self.timeon
                else:
                    self.totalon += (date-self.timeon) 
        if changeinfo.onacchange:
            self.onac = stateinfo.onac
            #if node just plugged in, record time plugged in
            if self.onac:
                if self.issuper and self.pluginwhilesuper >= 1:
                    print "PLUGGING IN AT ", self.bat, " ", date, " ", self
                if self.issuper:
                    self.pluginwhilesuper += 1
                self.timeac = date
                self.batrchg = self.bat
                if self.issuper:
                    if self.totalnotacsuper == None:
                        self.totalnotacsuper = date-self.timenotacsuper
                    else:
                        self.totalnotacsuper += (date-self.timenotacsuper)
            else:
                if self.issuper:
                    #print "unplugging while super", date, " ", self
                    self.timenotacsuper = date
                    #self.acchange = True
        
    def display(self):
        print "\tison: ", self.ison
        print "\tbat: ", self.bat
        print "\tonac: ", self.onac
        
        
"""
State of the communication layer.
"""        
class CommState:
    def __init__(self, id, neighbors, delay, numneighbors, numforsuper):
        self.id = id
        self.issuper = False
        self.neighborlist = neighbors[:]
        self.numneighbors = int(numneighbors)
        self.numforsuper = numforsuper
        
        #remove myself from neighborlist
        for i in range(len(self.neighborlist)):
            if self.neighborlist[i] == self.id:
                del self.neighborlist[i]
                break
            
        self.isjoining = False
        self.delay = datetime.timedelta(0, 0, int(delay))
        self.sendtime = datetime.timedelta(0, 0, 1000)
        self.refreshinterval = datetime.timedelta(0, 600, 0)
        
        self.neighborcache = None
        self.curneighbor = 0
        
    def randneighbor(self):
        num = random.randint(0, len(self.neighborlist)-1)
        return self.neighborlist[num]

    def clearNeighbors(self):
        if len(self.neighborlist) > 0:
            self.neighborcache = self.neighborlist[:]
        self.curneighbor= 0
        self.neighborlist = []

    def nextNeighbor(self):
        if self.curneighbor >= len(self.neighborcache):
            return None
        n = self.neighborcache[self.curneighbor]
        self.curneighbor += 1
        return n

"""
State of the application.
"""
class AppState:
    def __init__(self, algorithm):
        self.algorithm = algorithm