from datetime import *

class CommEventGenerator:
    def __init__(self):
        self.events = []
        
    def hasNext(self):
        if len(self.events) > 0:
            return True
        return False
    
    def peekNextEvent(self):
        if len(self.events) < 1:
            return None
        return self.events[0].date
        
    def getNextEvent(self):
        ev = self.events[0]
        del self.events[0]
        return ev
    
    def insertEvent(self, event):
        if len(self.events) < 1:
            self.events.append(event)
            return 
        i = 0
        while (i < len(self.events)) and self.events[i].date < event.date:
            i += 1
        if i == len(self.events):
            self.events.append(event)
        else:
           self.events.insert(i, event)  


class QueueManager:
    def __init__(self, deq, ceq, aeq=None):
        self.deq = deq
        self.ceq = ceq
        self.aeq = aeq
    
    def hasNext(self):
        if (self.deq != None and self.deq.hasNext()) or (self.ceq != None and self.ceq.hasNext()) or (self.aeq != None and self.aeq.hasNext()):
            return True
        return False
    
    def getNextEvent(self):
        mintime = None
        minq = None
        if (self.deq != None and self.deq.hasNext()):
            mintime = self.deq.peekNextEvent()
            minq = self.deq
        if (self.ceq != None and self.ceq.hasNext() and (mintime == None or self.ceq.peekNextEvent() < mintime)):
            mintime = self.ceq.peekNextEvent()
            minq = self.ceq
        if (self.aeq != None and self.aeq.hasNext() and (mintime == None or self.aeq.peekNextEvent() < mintime)):
            mintime = self.aeq.peekNextEvent()
            minq = self.aeq
        if minq == None:
            return None
        return minq.getNextEvent()
            