from config import *
from simconstants import *
import random
from events import *
from nodestate import *
from eventqueues import *
from flatnet import *
from supernet import *
from supernet_local import *
from oraclenet import *
import pickle, statistics, network_utils

class Network:
    def __init__(self, config):
        self.nodes = {}
        self.config = config

    def applyEvent(self, event):
        #node has not yet appeared in the network
        if not(self.nodes.has_key(event.id)):
            if self.config[RUNTYPE] == TYPE_FLAT:
                self.nodes[event.id] = FlatNode(event.id, False, 0, False, self.config)
            if self.config[RUNTYPE] == TYPE_ORACLE:
                self.nodes[event.id] = OracleNode(event.id, False, 0, False, self.config)
            if self.config[RUNTYPE] == TYPE_SUPER:
                self.nodes[event.id] = SuperNode(event.id, False, 0, False, self.config)
            if self.config[RUNTYPE] == TYPE_SUPER_LOCAL:
                self.nodes[event.id] = SuperNodeLocal(event.id, False, 0, False, self.config)
                    
        if isinstance(event, DeviceEvent):
            self.nodes[event.id].applyDeviceEvent(event)
            if event.changeinfo.onchange and event.stateinfo.ison: #device turned on
                newevent = self.nodes[event.id].startJoin(event.date, self.getNodesOnline())
                return newevent
            if event.changeinfo.onchange and not(event.stateinfo.ison):
                newevent = self.nodes[event.id].startLeave(event.date, self.getNodesOnline())
                return newevent

        if isinstance(event, CommEvent):
            newevent = self.nodes[event.id].applyCommEvent(event)
            if newevent != None:
                return newevent

        if isinstance(event, AppEvent):            
            newevent = self.nodes[event.id].applyAppEvent(event, self.getNodesOnline())
            if newevent != None:
                return newevent
                  
    def dumpStatistics(self):
        for key in self.nodes.keys():
            self.nodes[key].devicestate.dumpStatistics()
                          
    def getNodesOnline(self):
        ids = []
        for key in self.nodes.keys():
            if self.nodes[key].devicestate.ison == True:
                ids.append(self.nodes[key])
        return ids

            

def main(argv=None):
    """
    Sample usage of the EventGenerator

    for each event
        -change state of relevant node
        -if node came online
          *initiate join (update neighborlists as appropriate)
        -if node left
          *initiate rejoin for children if necessary
        -apply supernode selection criteria (does a new supernode need to be selected/a current node demoted?)
        -record statistics (e.g., time online, battery, failure rate)
    
    """

    argv = sys.argv

    config = Config()
    fname = config.params[PROGRAM][DATADIR]
    
    if len(argv) > 1:
        config.params[NETWORK][ALGORITHM] = argv[1]
    
    statistics.algorithm = config.params[NETWORK][ALGORITHM]
    
    network = Network(config.params[NETWORK])
    
    deq = DeviceEventGenerator(fname)
    ceq = CommEventGenerator()
    seq = SimEventGenerator()
    
    if config.params[PROGRAM].has_key(APPEVENTS):
        appfile = config.params[PROGRAM][APPEVENTS]
        f = open(appfile, "r")
        aeq = pickle.load(f)
        f.close()
    else:
        aeq = AppEventGenerator(deq.appdatanodes)
    
    mgr = QueueManager(deq, ceq, seq, aeq)
    
    while mgr.hasNext():
        ev = mgr.getNextEvent()
        if isinstance(ev, SimEvent):
            newev = ev.generateEvent(network.nodes[ev.sendid])
        else:
            newev = network.applyEvent(ev)

        if newev != None and isinstance(newev, Event):
            if isinstance(newev, DeviceEvent):
                deq.insertEvent(newev)
            elif isinstance(newev, CommEvent):
                ceq.insertEvent(newev)
            elif isinstance(newev, SimEvent):
                seq.insertEvent(newev)
            elif isinstance(newev, AppEvent):
                aeq.insertEvent(newev)
        elif newev != None:
            for i in newev:
                if isinstance(i, DeviceEvent):
                    deq.insertEvent(i)
                elif isinstance(i, CommEvent):
                    ceq.insertEvent(i)
                elif isinstance(i, SimEvent):
                    seq.insertEvent(i)
                elif isinstance(i, AppEvent):
                    aeq.insertEvent(i)
    
    network.dumpStatistics()
    
    statistics.printResults()

    #print statistics
    
    
     
    #print ev.statechange.date
    #keys = network.keys()
    #for key in keys:
    #    if network[key].ison == True:
    #        print "\t", network[key].id,
    #print


    #keys = network.keys()
    #for key in keys:
    #    network[key].display()


if (__name__ == "__main__"):
    sys.exit(main())

"""
class BasicNetwork(Network):
    def __init__(self, config):
        Network.__init__(self, config)

    def chooseNeighbors(self, id):

        #self.nodes[id].neighborlist
        ids = self.getNodesOnline()

        #if number of potential neighbors is less than or equal to number of required neighbors
        # add all (excluding the newly joined node)
        if len(ids)-1 <= int(self.config[NEIGHBORS]):
            for nid in ids:
                if nid != id:
                    self.nodes[id].neighborlist.append(nid)
        else:
            #choose a subset of available nodes (random?)
            chosen = {}
            while len(self.nodes[id].neighborlist) < int(self.config[NEIGHBORS]):
                num = random.randint(0, len(ids)-1)
                if ids[num] == id or (chosen.has_key(num) and chosen[num] == True):
                    continue
                chosen[num] = True
                self.nodes[id].neighborlist.append(ids[num])
        #print id
        #print "\tNeighbors ", self.nodes[id].neighborlist
        
    def balanceSupernodes(self, id):
        pass
    

"""

