"""
applayer_utils.py

This file contains the utilities to be used for simulating the application
portion of the system.

Author: Sami Rollins
"""

import simconstants

from event_generation_utils import Event

class TriggerEvent(Event):
    """
    TriggerEvent derives from event and contains information
    relevant to an event that will trigger a node to 
    process its outgoing message queue.
    """
    def __init__(self, id, date):
        Event.__init__(self, id, date)

class AppEvent(Event):
    """
    AppEvent derives from event and contains information relevant to an
    application-layer event.
    """
    def __init__(self, next_hop_id, date, uuid, orig_sender_id, final_dest_id, type, starttime=None, lasthop_id=None, sendattempts=0):
        """
        An AppEvent contains the following fields, in addition to Event's id and date:
        orig_sender_id - id (mac address) of the original sender of the message
        final_dest_id - id (mac address) of the final destination of the message
        type - type of event (see simconstants)
        starttime - date object representing the starttime of the event
        """
        Event.__init__(self, next_hop_id, date)
        self.uuid = uuid
        self.orig_sender_id = orig_sender_id
        self.final_dest_id = final_dest_id
        self.type = type
        if starttime == None:
            self.starttime = date
        else:    
            self.starttime = starttime
        #list to keep track of the hops this message has taken 
        #each item in the list is the id of a node that has processed the message
        self.hops = []
        #id of last sender
        self.lasthop_id = lasthop_id
        #number of failed send attempts
        self.sendattempts = sendattempts
        self.intransit = False
                    
    def __str__(self):
        returnstr = Event.__str__(self) + \
                   "\n\tUUID: " + self.uuid + \
                   "\n\tOriginal Sender ID: " + self.orig_sender_id + \
                   "\n\tFinal Destination ID: " + self.final_dest_id + \
                   "\n\tSTARTTIME: " + str(self.starttime) + \
                   "\n\tLASTHOP_ID: " + str(self.lasthop_id) + \
                   "\n\tINTRANSIT: " + str(self.intransit) + \
                   "\n\tTYPE: " + self.type
        
        return ("Application " + returnstr)


"""
class AppIDEvent(AppEvent):
    def __init__(self, id, date, sendid, destid, sendchain, type, starttime, evid):
        AppEvent.__init__(self, id, date, sendid, destid, sendchain, type, starttime)
        self.evid = evid

class AppQueryEvent(AppIDEvent):
    def __init__(self, id, date, sendid, destid, sendchain, type, starttime, evid, devicestate = None):
        AppIDEvent.__init__(self, id, date, sendid, destid, sendchain, type, starttime, evid)
        self.devicestate = devicestate
"""