import ConfigParser, sys
from simconstants import *

class Config:
    def __init__(self):
        config = ConfigParser.ConfigParser()
        config.read(CONFIGFNAME)
        self.params = {}
        #from: http://effbot.org/librarybook/configparser.htm
        for section in config.sections():
            self.params[section] = {}
            for option in config.options(section):
                if option == SEEDS:
                    self.params[section][option] = config.get(section, option).split()
                else:
                    self.params[section][option] = config.get(section, option)

    def display(self):
        sections = self.params.keys()
        for section in sections:
            print section
            for option in self.params[section]:
                print option, " = ", self.params[section][option]

def main(argv=None):
    c = Config()
    c.display()

if (__name__ == "__main__"):
    sys.exit(main())
