from simconstants import *
from device_utils import *
from applayer_utils import *

import random, statistics, copy

"""
Need to determine when/how to update the predictor
In reality, decisions will not be made based upon perfect knowledge
Perhaps every x min apply changes to the predictor

Need to figure out how to configure the predictor scheme
"""


class Node:
    def __init__(self, id):
        self.id = id 
        self.stateinfo = None
        self.msgq = {}
        
    def changeState(self, stateinfo):
        """
        Keep track of history
        feed in to predictor periodically
        """
        self.stateinfo = stateinfo
        
    def nodeIsOn(self):
        if self.stateinfo != None and self.stateinfo.ison:
            return True
        return False    
    
    def __str__(self):
        statestr = self.stateinfo.__str__()
        return ("Node " + self.id + ": " + statestr)


class Network:
    def __init__(self, allids):
        self.nodes = {}
        for i in allids:
            logger.debug("adding new node ", i ," to network ")
            self.nodes[i] = Node(i)
            
        if simconstants.type == ORACLE:
            self.nodes[ORACLE] = Node(ORACLE)
            self.nodes[ORACLE].stateinfo = DeviceStateInfo(ison=True, bat=100, onac=True)
            
    def initEvents(self, firstdate):
        events = []
        for i in self.nodes.keys():
            events.append(TriggerEvent(i, (firstdate + getTriggerDelta())))
        return events

    def printStats(self):
        count = 0
        for i in self.nodes.keys():
            for j in self.nodes[i].msgq.keys():
                count += 1
                print self.nodes[i].msgq[j].uuid
        print "Total Undelivered: ", count
        
        print "Unplugged hops ", (float(len(statistics.unpluggedhops))/float(statistics.totalhops)) 
                
    def applyEvent(self, event):
        #node has not yet appeared in the network
        if not(self.nodes.has_key(event.id)):
            logger.warning("ERROR: event generated for node ", i, " but node not in network")
            self.nodes[event.id] = Node(event.id)
            
        if isinstance(event, DeviceEvent):
            self.nodes[event.id].changeState(event.stateinfo)
            if event.changeinfo.onchange and event.stateinfo.ison:
                return self.processMsgQueue(self.nodes[event.id], event.date)         
                      
        elif isinstance(event, AppEvent):
            return self.processAppEvent(event)
        elif isinstance(event, TriggerEvent):
            if event.id == ORACLE:
                allon = self.getKeysForOnNodes()
                print allon
                if len(allon) < 2:
                    print "ORACLE ONLY ON NODE ", str(event.date)
            return self.processTriggerEvent(event)
                
    def processAppEvent(self, event):
        
        returnevents = []
        curnode = self.nodes[event.id]
        ison = self.nodes[event.id].nodeIsOn()
        
            
        if event.type == ORIG and not(ison):
            #print ("ERROR: event type is ORIG but node to process is off " + event.uuid + " date " + str(event.date))
            #event.date = event.date + getNextTimeUnit()
            #returnevents.append(event)
            #return returnevents
            """Original event but node is not on"""
            """Two cases: msg and on event generated at same time and msg processed before on event OR
                            msg and off event generated at same time and off processed before msg
                In either case, just queue the msg and it will be processed at the next on time
            """
            curnode.msgq[event.uuid] = event
        
        elif event.type == ORIG and ison:
            logger.debug("Original event " + event.uuid)
            curnode.msgq[event.uuid] = event
            relay = self.generateRelay(event, event.date, curnode)
            if relay != None:
                returnevents.append(relay)
            return returnevents
        
        elif event.type == RELAY and not(ison):
            logger.debug("Received relay but not on, returning fail " + event.uuid)
            returnevents.append(self.generateFail(event))
            return returnevents
        
        elif event.type == RELAY and ison:
            
            if event.final_dest_id == curnode.id:
                """FIXME: Statistics!!!"""
                statistics.msgtimes.append((event.date-event.starttime))
                statistics.hops.append(len(event.hops))
                logger.debug("Received message destined for me " + event.uuid + " time: " + str(event.date))
                logger.debug("Time in transit: " + str(event.date-event.starttime))
                logger.debug("Number of hops: " + str(len(event.hops)))
                logger.debug(event.hops)
            else:
                logger.debug("Received message for RELAY " + event.uuid)
                event.intransit = False
                curnode.msgq[event.uuid] = event
                
                if curnode.stateinfo.onac == False:
                    statistics.unpluggedhops.append(event)
                    statistics.totalhops += 1
                else:
                    statistics.totalhops += 1
                                
            del self.nodes[event.lasthop_id].msgq[event.uuid]
            return returnevents
        
        
        elif event.type == FAIL:
            #failure to deliver msg
            #leave in queue, set intransit to be false
            #will be retried at the next trigger event
            curnode.msgq[event.uuid].intransit = False
            curnode.msgq[event.uuid].type = RELAY

    def generateRelay(self, event, curtime, sendnode):
            id = self.getNextHop(event)
            if id == None:
                return None
            event.id = id
            event.date = curtime + getTimeDelta()
            event.type = RELAY
            event.intransit = True
            if event.lasthop_id == None or event.lasthop_id != sendnode.id: 
                event.hops.append(sendnode.id)
                event.lasthop_id = sendnode.id
            return event
          
    def processMsgQueue(self, node, curtime):
        returnevents = []        
        msgq = node.msgq
        for i in msgq.keys():
            if msgq[i].intransit == False:
                relay = self.generateRelay(msgq[i], curtime, node)
                if relay != None:
                    returnevents.append(relay)
        return returnevents

    def processTriggerEvent(self, event):
        returnevents = []
        curnode = self.nodes[event.id]
        ison = self.nodes[event.id].nodeIsOn()

        if not(ison):
            logger.debug("Trigger received but not on, returning next trigger")
            returnevents.append(self.generateNextTrigger(event))
            return returnevents
        else:
            returnevents = self.processMsgQueue(self.nodes[event.id], event.date)
            returnevents.append(self.generateNextTrigger(event))
            return returnevents

    def generateNextTrigger(self, event):
        event.date = event.date + getTriggerDelta()
        return event
        
    def generateAck(self, event):
        ack = AppEvent(event.lasthop_id, (event.date+getTimeDelta()), event.uuid, event.orig_sender_id, event.final_dest_id, ACK, event.date, lasthop_id=event.id)
        return ack
    
    def generateFail(self, event):
        event.type = FAIL
        event.date = event.date + getTimeDelta()
        event.id = event.lasthop_id
        event.sendattempts += 1
        return event
    
    def getKeysForOnNodes(self):
        keystoreturn = []
        for i in self.nodes.keys():
            if self.nodes[i].nodeIsOn():
                keystoreturn.append(i)
        return keystoreturn
    
    def getNextHop(self, event):

        #if destination is on, send directly for all algorithms
        if self.nodes[event.final_dest_id].nodeIsOn():
            return event.final_dest_id
        
        if simconstants.type == ORACLE:
            if event.lasthop_id == None:
                return ORACLE
            return None
        
        #if algorithm is direct, no next hop if destination not on
        if simconstants.type == DIRECT:
            return None 
        #if algorithm is random, select random node from set of nodes currently on
        if simconstants.type == RANDOM:
            ids = self.getKeysForOnNodes()
            #current node will be returned as 1 on node, need at least
            #2 in order for a valid next hop to be available
            if len(ids) < 2:
                return None
            randnum = random.randint(0, len(ids)-1)
            #don't send to self
            while ids[randnum] == event.id:
                randnum = random.randint(0, len(ids)-1)
            return ids[randnum]
        
        return None