import copy, pickle, datetime
from applayer_utils import *
from device_utils import *
from simconstants import *

import statistics

"""
This is a standalone module used to determine the best case performance
of an opportunistic routing algorithm that uses an oracle to determine
best routes.  
"""


"""FIXME - make input pkl with events a configuration parameter"""
f = open('tmp.pkl', "r")
eventq = pickle.load(f)
allids = pickle.load(f)
simend = pickle.load(f)
f.close()

nodes = {} #list of nodes currently on
allmsgs = {} #all messages that have been sent and not delivered


class Msg:
    """ 
    Msg class holds relevant information about a single message.
    dest - final destination of message
    uuid - unique id of the message
    starttime - time message first introduced
    hops - list of ids of nodes that have transferred the message
    """
    def __init__(self, dest, uuid, starttime, hops=None):
        self.dest = dest
        self.uuid = uuid
        self.starttime = starttime
        if hops == None:
            self.hops = []
        else:
            self.hops = hops
        self.acstats = []

class Node:
    """
    Node class holds relevant information for a node.
    id - id of node (MAC addr)
    msgs - hash table of messages the node currently holds
    """
    def __init__(self, id, onac, bat, msgs=None):
        self.id = id
        self.onac = onac
        self.bat = bat
        if msgs == None:
            self.msgs = {}
        else:
            self.msgs = msgs

#for each event
while eventq.hasNext() and eventq.peekNextEvent() < simend:
    nextevent = eventq.getNextEvent()
    
    #if device event
    if isinstance(nextevent, DeviceEvent):
        
        #if turning off, delete message queue
        if nextevent.changeinfo.onchange and not(nextevent.stateinfo.ison):
            del nodes[nextevent.id]

        #if turning on, 
        elif nextevent.changeinfo.onchange and nextevent.stateinfo.ison:
            #add node to list of on nodes
            n = Node(nextevent.id, nextevent.stateinfo.onac, nextevent.stateinfo.bat)
            #holds messages that arrive at the node
            arrived = {}
            #for each other node in the system, get messages from it
            for i in nodes.values():
                
                #for each message held by an existing node 
                for j in i.msgs.keys():
                    
                    #if i am the final destination, queue the message
                    #save all copies coming from all nodes in the network and post-process to determine
                    #which had shortest travel time
                    if i.msgs[j].dest == nextevent.id:
                        if not(arrived.has_key(j)):
                            arrived[j] = []
                            del allmsgs[j]
                        i.msgs[j].hops.append(nextevent.id)
                        #if not(i.onac):
                        #    i.msgs[j].acstats.append(i.bat)
                        arrived[j].append(i.msgs[j])
                        
                    #if i don't have the message or if the copy of the msg I have has been through more hops than the copy the other guy has
                    # store a copy of the message in my list and add myself to the hops
                    elif not(n.msgs.has_key(j)) or (len(n.msgs[j].hops) > len(i.msgs[j].hops)):
                        n.msgs[j] = copy.deepcopy(i.msgs[j])
                        n.msgs[j].hops.append(nextevent.id)
                        if not(n.onac):
                            n.msgs[j].acstats.append(n.bat)
                        else:
                            n.msgs[j].acstats.append("ONAC")
                        
            #for each of the messages that have arrived
            for i in arrived.keys():
                
                #delete message from all other message queues
                for j in nodes.values():
                    for k in j.msgs.keys():
                        if k == i:
                            del j.msgs[k]
                            
                #determine the time/hops for the message to reach current node
                options = arrived[i]
                minhops = -1
                minhopstime = None
                mintime = None
                mintimehops = -1
                msg = None
                for j in options:
                    if mintime == None or (nextevent.date-j.starttime) < mintime:
                        mintime = nextevent.date-j.starttime
                        mintimehops = len(j.hops)
                        msg = j
                    if minhops == -1 or len(j.hops) < minhops:
                        minhops = len(j.hops)
                        minhopstime = nextevent.date-j.starttime
                statistics.msgtimes.append(mintime+datetime.timedelta(seconds=1))
                statistics.hops.append(mintimehops)
                print "hops ", mintimehops
                #print "battery spent ", msg.uuid                     
                print msg.acstats
                print "**"       
                for i in msg.acstats:
                    statistics.totalhops += 1
                    if i != "ONAC":
                        statistics.notac += 1
                
            #add myself to the node queue
            nodes[nextevent.id] = n
              
        elif nextevent.stateinfo.ison:
            if nextevent.changeinfo.onacchange:
                nodes[nextevent.id].onac = nextevent.stateinfo.onac
            if nextevent.changeinfo.batchange:
                nodes[nextevent.id].bat = nextevent.stateinfo.bat
            
    #if the event is a new message
    elif isinstance(nextevent, AppEvent):
        if nextevent.type == ORIG:
            #add to message list
            allmsgs[nextevent.uuid] = True
            #if sender not on, delay message for 1 second
            if not(nodes.has_key(nextevent.id)):
                nextevent.date = nextevent.date+datetime.timedelta(seconds=1)
                eventq.insertEvent(nextevent)

            else:
                found = False
                for i in nodes.keys():
                    #if message destination is on, deliver in 1 second
                    """FIXME - make time to deliver message configurable (not fixed 1 second)"""
                    if i == nextevent.final_dest_id:
                        found = True
                        statistics.msgtimes.append(datetime.timedelta(seconds=1))
                        statistics.hops.append(1)
                        del allmsgs[nextevent.uuid]
                        break
                #if the destination is not on, add message to my queue and the queue of everyone else
                if not(found):
                    for i in nodes.keys():
                        if i == nextevent.id:
                            nodes[i].msgs[nextevent.uuid] = Msg(nextevent.final_dest_id, nextevent.uuid, nextevent.starttime)
                        else:
                            m = Msg(nextevent.final_dest_id, nextevent.uuid, nextevent.starttime, [nextevent.orig_sender_id])
                            if not nodes[i].onac:
                                m.acstats.append(nodes[i].bat)
                            else:
                                m.acstats.append("ONAC")
                            nodes[i].msgs[nextevent.uuid] = m

#print statistics
for i in allmsgs.keys():
    print i
print "Total Undelivered: ", len(allmsgs.keys())
statistics.printTimes()
statistics.printHops()
print "percentage unplugged hops ", (float(statistics.notac)/float(statistics.totalhops))